/*
 * Decompiled with CFR 0.152.
 */
package com.nethersdelight.common.block;

import com.nethersdelight.core.registry.NDBlocks;
import com.nethersdelight.core.tag.NDTags;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SoulCompostBlock
extends Block {
    public static IntegerProperty COMPOSTING = IntegerProperty.m_61631_((String)"composting", (int)0, (int)3);

    public SoulCompostBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)COMPOSTING, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{COMPOSTING});
        super.m_7926_(builder);
    }

    public int getMaxCompostingStage() {
        return 3;
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if (worldIn.f_46443_) {
            return;
        }
        float chance = 0.0f;
        boolean hasLava = false;
        boolean isSoulValley = false;
        for (BlockPos neighborPos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-1, -1, -1), (BlockPos)pos.m_142082_(1, 1, 1))) {
            BlockState neighborState = worldIn.m_8055_(neighborPos);
            if (neighborState.m_204336_(NDTags.SOUL_COMPOST_ACTIVATORS)) {
                chance += 0.015f;
            }
            if (neighborState.m_60819_().m_205070_(FluidTags.f_13132_)) {
                hasLava = true;
            }
            if (neighborState.m_204336_(NDTags.SOUL_COMPOST_FLAMES)) {
                chance += 0.015f;
            }
            if (worldIn.m_204166_(pos) != Biomes.f_48199_) continue;
            isSoulValley = true;
        }
        chance += hasLava ? 0.06f : 0.02f;
        chance += isSoulValley ? 0.12f : 0.0f;
        if (worldIn.m_5822_().nextFloat() <= chance && worldIn.m_6042_().m_63951_()) {
            if (((Integer)state.m_61143_((Property)COMPOSTING)).intValue() == this.getMaxCompostingStage()) {
                worldIn.m_7731_(pos, ((Block)NDBlocks.RICH_SOUL_SOIL.get()).m_49966_(), 2);
            } else {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)COMPOSTING, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)COMPOSTING) + 1)), 2);
            }
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return this.getMaxCompostingStage() + 1 - (Integer)blockState.m_61143_((Property)COMPOSTING);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        super.m_7100_(stateIn, worldIn, pos, rand);
        if (rand.nextInt(30) == 0) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_() + (double)rand.nextFloat(), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + (double)rand.nextFloat(), 0.0, 0.0, 0.0);
        }
    }
}

